/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataFormatter;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmDataValidator;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Wcl_CommonFunctionsNode;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.RequiredValidator;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.ComponentReset;
import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.servlet.pmod.util.ObjectFormatter;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.components.message.IMessageConsumer;
import com.ibm.psw.wcl.components.message.IMessageProducer;
import com.ibm.psw.wcl.components.message.MessageInfo;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class WclGlueValidator
implements IMessageProducer {
    private static final String TRACE_MASKF = "XPMWGLVF";
    private List validators = new ArrayList();
    private PmDataFormatter formatter = null;
    private Class propertyType = null;
    private String objectScopeId = null;
    private Wcl_CommonFunctionsNode node = null;
    private PanelModel panelModel = null;
    private Set consumerList = new HashSet();
    private String lastErrorMessageId = null;
    protected WComponent component = null;

    public WclGlueValidator(Wcl_CommonFunctionsNode node, String objectScopeId) {
        this.objectScopeId = objectScopeId;
        this.node = node;
    }

    public Wcl_CommonFunctionsNode getNode() {
        return this.node;
    }

    private PanelModel getPanelModel() {
        if (this.panelModel == null && this.node != null) {
            this.panelModel = this.node.getPanelModel();
        }
        return this.panelModel;
    }

    public String getObjectScopeId() {
        return this.objectScopeId;
    }

    public void setComponent(WComponent component) {
        this.component = component;
        Iterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            ((PmDataValidator)iterator.next()).setComponent(component);
        }
    }

    public void setFormatter(PmDataFormatter formatter) {
        this.formatter = formatter;
    }

    public List getValidators() {
        return this.validators;
    }

    public void addValidator(PmDataValidator pmDataValidator) {
        Trace.trace(TRACE_MASKF, "addValidator() entry (" + pmDataValidator + ")");
        pmDataValidator.setLocale(this.getPanelModel().getImplAccess().getPanelModelTaskPortal().getHMCSession().getUserContext().getLocale());
        if (this.component != null) {
            pmDataValidator.setComponent(this.component);
        }
        if (pmDataValidator instanceof RequiredValidator) {
            RequiredValidator rv = (RequiredValidator)pmDataValidator;
            if (this.node instanceof Wcl_CommonFunctionsNode) {
                rv.setPropertyName(this.node.getProperty());
            } else {
                Trace.trace(TRACE_MASKF, "Warning: 'node' wasn't a Wcl_CommonFunctionsNode");
            }
            rv.setWclCommonFunctionsNode(this.node);
            this.node.getPanelModel().getImplAccess().getWclEventProxyManager().addRequiredValidator(rv);
        } else {
            this.validators.add(pmDataValidator);
        }
    }

    public PmDataFormatter getFormatter() {
        return this.formatter;
    }

    public void setPropertyType(Class propertyType) {
        this.propertyType = propertyType;
    }

    public void validate(Object newValue) throws ValidationException {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() entry (" + this + ")");
        PanelModel pm = this.panelModel == null ? this.node.getDocumentRoot().getPanelModel().getImplAccess().getOuterMostPanelModel() : this.panelModel;
        try {
            if (!this.validators.isEmpty()) {
                Trace.trace(TRACE_MASKF, "Validator(s) exists");
                if (this.formatter != null) {
                    Trace.trace(TRACE_MASKF, "Formatter exists so we'll call parse() prior to validator(s)");
                    this.runValidators(this.formatter.parse(newValue));
                } else if (this.propertyType != null) {
                    Trace.trace(TRACE_MASKF, "No formatter exists so we'll implicitly convert and pass result to validator(s)");
                    try {
                        this.runValidators(ObjectFormatter.convert(newValue, this.propertyType));
                    }
                    catch (NoStandardFormatterException e) {
                        Trace.trace(TRACE_MASKF, "No standard conversion available, so we'll just call validator(s) with the raw data.");
                        this.runValidators(newValue);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "No formatter exists and we couldn't determine property type, so we'll just pass the raw data to the real validator(s).");
                    this.runValidators(newValue);
                }
            } else if (this.formatter != null) {
                Trace.trace(TRACE_MASKF, "No validators exists but a formatter exists, we'll just call parse() on it.");
                this.formatter.parse(newValue);
            } else {
                Trace.trace(TRACE_MASKF, "WARNING No validators, no formatters... unexpected this is.");
            }
        }
        catch (ValidationException e) {
            Trace.trace(TRACE_MASKF, "ValidationException caught.  \n\tMessage is: " + e.getMessage() + "\n\tCause is: " + e.getCause());
            if (this.node != null) {
                if (this.node.isEnableEnabled() && !this.node.isEnabled()) {
                    this.clearErrors();
                    Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() passes (" + this + ") (node !enabled)");
                    return;
                }
                if (this.node.isReadonlyEnabled() && this.node.isReadonly()) {
                    this.clearErrors();
                    Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() passes (" + this + ") (node was readonly)");
                    return;
                }
            }
            this.handleValidationException(e);
            Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() fails (" + this + ") (ValidationException)");
            throw e;
        }
        Trace.trace(TRACE_MASKF, "WclGlueValidator.validate() passes (" + this + ")");
        this.clearErrors();
    }

    public void clearErrors() {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.clearErrors()");
        if (this.lastErrorMessageId != null) {
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.removeMessage(this.lastErrorMessageId);
            }
            this.lastErrorMessageId = null;
        }
    }

    public void handleValidationException(Exception e) {
        Trace.trace(TRACE_MASKF, "WclGlueValidator.handleValidationException(" + e + ")");
        this.clearErrors();
        if (e instanceof ValidationException && ((ValidationException)e).getMessageText() != null) {
            Trace.trace(TRACE_MASKF, "messageText != null");
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.addMessage(new MessageInfo(Locale.getDefault(), ((ValidationException)e).getMessageText().getKey(), ((ValidationException)e).getMessageText().getResourceBundleName(), ((ValidationException)e).getMessageText().getMsgId(), 1, 0, ((ValidationException)e).getMessageText().getSubstitutionData(), null, false));
            }
            this.lastErrorMessageId = ((ValidationException)e).getMessageText().getMsgId();
        } else {
            Trace.trace(TRACE_MASKF, "messageText == null");
            Iterator iterator = this.consumerList.iterator();
            while (iterator.hasNext()) {
                IMessageConsumer consumer = (IMessageConsumer)iterator.next();
                consumer.addMessage(new MessageInfo(Locale.getDefault(), "GenericEmptyMessage", "com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "", 1, 0, new Object[]{e.getLocalizedMessage()}, null, false));
                this.lastErrorMessageId = "";
            }
        }
        if (this.component instanceof AWInputComponent) {
            ((AWInputComponent)this.component).setStatus(2, true);
            ((AWInputComponent)this.component).setStatusText(e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), 2);
            ((AWInputComponent)this.component).setDirty(true);
            this.getPanelModel().getImplAccess().addPostSerializeAction(new ComponentReset((AWInputComponent)this.component, this));
        }
    }

    private void runValidators(Object formattedObject) throws ValidationException {
        Trace.trace(TRACE_MASKF, "Running validators.");
        Iterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            PmDataValidator validator = (PmDataValidator)iterator.next();
            validator.validate(formattedObject);
        }
    }

    public void addConsumer(IMessageConsumer consumer) {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("addConsumer(").append(consumer == null ? "null" : consumer.getClass().getName()).append(")"));
        if (consumer != null) {
            this.consumerList.add(consumer);
        }
    }

    public void removeConsumer(IMessageConsumer consumer) {
        Trace.trace(TRACE_MASKF, StringUtils.getThreadLocalStringBuffer().append("removeConsumer(").append(consumer == null ? "null" : consumer.getClass().getName()).append(")"));
        this.consumerList.remove(consumer);
    }
}

